@extends('admin.layout.page-app')
@section('page_title', __('label.group_battles'))
@section('tab_title', __('label.group_battles'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.group_battles')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.group_battles')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Search && Table -->
            <div class="card custom-border-card mt-3">
                <div class="page-search">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl"></i></span>
                        </div>
                        <input type="text" id="input_search" class="form-control" placeholder="{{__('label.search')}}" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                     <div class="sorting mr-2 w-50">
                        <label>{{__('label.start')}} : </label>
                        <input type="date" name="input_start_date" id="input_start_date" value="{{ date('Y-m-d') }}" class="form-control" max="{{ date('Y-m-d') }}">
                    </div>
                    <div class="sorting mr-2 w-50">
                        <label>{{__('label.end')}} : </label>
                        <input type="date" name="input_end_date" id="input_end_date" value="{{ date('Y-m-d') }}" class="form-control" max="{{ date('Y-m-d') }}">
                    </div>
                </div>
                <div class="page-search mb-3">
                    <div class="sorting mr-2 w-50">
                        <label>{{__('label.sort_by')}}</label>
                        <select class="form-control" name="input_c_user_id" id="input_c_user_id">
                            <option value="0" selected>{{__('label.all_creators')}}</option>
                            @for ($i = 0; $i < count($user); $i++)
                                <option value="{{ $user[$i]['id'] }}">
                                    {{ $user[$i]['user_name'] }} | {{ $user[$i]['full_name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2">
                        <select class="form-control" name="input_status" id="input_status">
                            <option value="all">{{__('label.all_status')}}</option>
                            <option value="0">{{__('label.pending')}}</option>
                            <option value="2">{{__('label.started')}}</option>
                            <option value="1">{{__('label.completed')}}</option>
                        </select>
                    </div>
                </div>

                <div class="table-responsive table">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr>
                                <th>{{__('label.#')}}</th>
                                <th>{{__('label.room')}}</th>
                                <th>{{__('label.created_by')}}</th>
                                <th>{{__('label.joining_fee')}}</th>
                                <th>{{__('label.winning_coin')}}</th>                                
                                <th>{{__('label.questions')}}</th>
                                <th>{{__('label.status')}}</th>
                                <th>{{__('label.action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <script>
        $("#input_c_user_id").select2();

        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax:
                    {
                    url: "{{ route('admin.group_battles.index') }}",
                    data: function(d){
                        d.input_search = $('#input_search').val();
                        d.input_start_date = $('#input_start_date').val();
                        d.input_end_date = $('#input_end_date').val();
                        d.input_c_user_id = $('#input_c_user_id').val();
                        d.input_status = $('#input_status').val();
                    },
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
                    {
                        data: 'room',
                        name: 'room',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `<div>
                                        <div style="text-align: center; font-size: 18px; font-weight: 600; letter-spacing: 3px;" class="primary-color">${row.room_code ?? '-'}</div>
                                        <div style="text-align: left; font-size: 14px; font-weight: 600;">${row.name ?? ''}</div>
                                    </div>`;
                        }
                    },
                    {
                        data: 'created_user',
                        name: 'created_user',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            let color = '';
                            if (data?.id === row.w_user_id) {
                                color = 'color: var(--green-color);';
                            }
                            return `<div style="text-align: left; ${color}">
                                        ${data?.user_name ?? '-'}<br><span style="font-size: 14px; font-weight: 600;">${data?.full_name ?? '-'}</span>
                                    </div>`;
                        }
                    },
                    {
                        data: 'joining_coin',
                        name: 'joining_coin',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;">${data ?? 0}</span>`;
                        }
                    },
                    {
                        data: 'winning_coin',
                        name: 'winning_coin',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="primary-color">${data ?? 0}<i class="fa-solid fa-sack-dollar ml-3 fa-lg"></i></span>`;
                        }
                    },
                    {
                        data: 'total_questions',
                        name: 'total_questions',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;">${data ?? 0}</span>`;
                        }
                    },
                    {
						data: 'status',
						name: 'status',
					},
					{ data: 'action', name: 'action', orderable: false, searchable: false }
                ],
            });

            $('#input_c_user_id, #input_status, #input_start_date, #input_end_date').change(function(){
                table.draw();
            });
            $('#input_search').keyup(function() {
                table.draw();
            });
        });
    </script>
@endsection